/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.crypto.IVerifyable;
import anon.crypto.MultiCertPath;
import anon.crypto.SignatureVerifier;
import anon.crypto.XMLSignature;
import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.Constants;
import anon.infoservice.Database;
import anon.infoservice.IDistributable;
import anon.infoservice.MixCascade;
import anon.infoservice.PerformanceEntry;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class StatusInfo
extends AbstractDatabaseEntry
implements IDistributable,
IVerifyable,
IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "MixCascadeStatus";
    public static final String XML_ELEMENT_CONTAINER_NAME = "MixCascadeStatusList";
    public static final int ANON_LEVEL_MIN = 0;
    public static final int ANON_LEVEL_MAX = 6;
    private String m_mixCascadeId;
    private long m_lastUpdate;
    private int m_nrOfActiveUsers;
    private int m_currentRisk;
    private int m_trafficSituation;
    private long m_mixedPackets;
    private int m_anonLevel;
    private String m_statusXmlData;
    private byte[] m_statusXmlDataBytes;
    private XMLSignature m_signature;
    private MultiCertPath m_certPath;
    static /* synthetic */ Class class$anon$infoservice$StatusInfo;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;
    static /* synthetic */ Class class$anon$infoservice$PerformanceEntry;

    public static StatusInfo createDummyStatusInfo(String a_mixCascadeId) {
        return new StatusInfo(a_mixCascadeId, -1, -1, -1, -1L, -1);
    }

    public static String getXmlElementName() {
        return XML_ELEMENT_NAME;
    }

    public StatusInfo(Element a_statusNode) throws Exception {
        this(a_statusNode, -1L);
    }

    public StatusInfo(Element a_statusNode, long a_timeout) throws Exception {
        super(System.currentTimeMillis() + (a_timeout <= 0L ? 480000L : a_timeout));
        if (a_statusNode == null) {
            throw new XMLParseException("##__null__##");
        }
        if (!a_statusNode.getNodeName().equals(XML_ELEMENT_NAME)) {
            throw new XMLParseException("##__root__##");
        }
        this.m_mixCascadeId = a_statusNode.getAttribute("id");
        int certificateLock = -1;
        try {
            this.m_signature = SignatureVerifier.getInstance().getVerifiedXml(a_statusNode, 1);
            if (this.m_signature != null) {
                this.m_certPath = this.m_signature.getMultiCertPath();
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.CRYPTO, "Error while verifying status info certificates!", e);
        }
        if (!this.checkId()) {
            throw new XMLParseException("##__root__##", "Malformed Status-Entry for Mix ID: " + this.m_mixCascadeId);
        }
        this.m_currentRisk = Integer.parseInt(a_statusNode.getAttribute("currentRisk"));
        this.m_mixedPackets = Long.parseLong(a_statusNode.getAttribute("mixedPackets"));
        this.m_nrOfActiveUsers = Integer.parseInt(a_statusNode.getAttribute("nrOfActiveUsers"));
        this.m_trafficSituation = Integer.parseInt(a_statusNode.getAttribute("trafficSituation"));
        this.m_lastUpdate = Long.parseLong(a_statusNode.getAttribute("LastUpdate"));
        this.m_anonLevel = -1;
        if (this.getNrOfActiveUsers() >= 0 && this.getTrafficSituation() >= 0) {
            this.m_anonLevel = this.getNrOfActiveUsers() < 30 ? 0 : (this.getNrOfActiveUsers() < 90 ? 1 : (this.getNrOfActiveUsers() < 200 ? 2 : (this.getNrOfActiveUsers() < 300 ? 3 : (this.getNrOfActiveUsers() < 400 ? 4 : (this.getNrOfActiveUsers() < 500 ? 5 : 6)))));
        }
        if (XMLUtil.getStorageMode() == 2) {
            this.m_statusXmlData = null;
            this.m_statusXmlDataBytes = null;
        } else {
            this.m_statusXmlData = XMLUtil.toString(a_statusNode);
            this.m_statusXmlDataBytes = this.m_statusXmlData.getBytes();
        }
    }

    private StatusInfo(String a_mixCascadeId, int a_nrOfActiveUsers, int a_currentRisk, int a_trafficSituation, long a_mixedPackets, int a_anonLevel) {
        super(System.currentTimeMillis() + 480000L);
        this.m_mixCascadeId = a_mixCascadeId;
        this.m_lastUpdate = System.currentTimeMillis();
        this.m_nrOfActiveUsers = a_nrOfActiveUsers;
        this.m_currentRisk = a_currentRisk;
        this.m_trafficSituation = a_trafficSituation;
        this.m_mixedPackets = a_mixedPackets;
        this.m_anonLevel = a_anonLevel;
        this.m_statusXmlData = XMLUtil.toString(this.generateXmlRepresentation());
        this.m_statusXmlDataBytes = this.m_statusXmlData.getBytes();
    }

    public String getId() {
        return this.m_mixCascadeId;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public long getVersionNumber() {
        return this.getLastUpdate();
    }

    public int getNrOfActiveUsers() {
        return this.m_nrOfActiveUsers;
    }

    public int getCurrentRisk() {
        return this.m_currentRisk;
    }

    public int getTrafficSituation() {
        return this.m_trafficSituation;
    }

    public long getMixedPackets() {
        return this.m_mixedPackets;
    }

    public int getAnonLevel() {
        return this.m_anonLevel;
    }

    public boolean isVerified() {
        if (this.m_signature != null) {
            return this.m_signature.isVerified();
        }
        return false;
    }

    public boolean isValid() {
        if (this.m_certPath != null) {
            return this.m_certPath.isValid(new Date());
        }
        return false;
    }

    public XMLSignature getSignature() {
        return this.m_signature;
    }

    public MultiCertPath getCertPath() {
        return this.m_certPath;
    }

    public boolean checkId() {
        return !SignatureVerifier.getInstance().isCheckSignatures() || this.m_signature != null && this.m_signature.getXORofSKIs().equalsIgnoreCase(this.getId());
    }

    public String getPostFile() {
        return "/feedback";
    }

    public static StatusInfo getStatusInfo(MixCascade a_service) {
        if (a_service == null) {
            return null;
        }
        StatusInfo status = (StatusInfo)Database.getInstance(class$anon$infoservice$StatusInfo == null ? (class$anon$infoservice$StatusInfo = StatusInfo.class$("anon.infoservice.StatusInfo")) : class$anon$infoservice$StatusInfo).getEntryById(a_service.getId());
        return status;
    }

    public byte[] getPostData() {
        return this.m_statusXmlDataBytes;
    }

    public int getPostEncoding() {
        return 0;
    }

    public String getStatusXmlData() {
        return this.m_statusXmlData;
    }

    public String getHtmlTableLine(boolean a_bPassiveMode) {
        String htmlTableLine = "<TR><TD CLASS=\"name\">";
        MixCascade ownMixCascade = (MixCascade)Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = StatusInfo.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryById(this.getId());
        PerformanceEntry perfEntry = (PerformanceEntry)Database.getInstance(class$anon$infoservice$PerformanceEntry == null ? (class$anon$infoservice$PerformanceEntry = StatusInfo.class$("anon.infoservice.PerformanceEntry")) : class$anon$infoservice$PerformanceEntry).getEntryById(this.getId());
        int maxUsers = 0;
        if (ownMixCascade != null) {
            htmlTableLine = htmlTableLine + ownMixCascade.getName();
            maxUsers = ownMixCascade.getMaxUsers();
        }
        String trafficString = this.getTrafficSituation() < 0 ? "(n/a)" : Integer.toString(this.getTrafficSituation()) + " ";
        if (this.getTrafficSituation() > 60) {
            trafficString = trafficString + "(high)";
        } else if (this.getTrafficSituation() > 30) {
            trafficString = trafficString + "(medium)";
        } else if (this.getTrafficSituation() >= 0) {
            trafficString = trafficString + "(low)";
        }
        htmlTableLine = htmlTableLine + "</TD><TD CLASS=\"name\"><a href=\"" + "/cascadewebinfo/" + this.getId() + "\">" + this.getId() + "</a></TD><TD CLASS=\"status\" ALIGN=\"right\">" + (!a_bPassiveMode ? "<a href=\"/values/users/" + this.getId() + "\">" : "") + (this.getNrOfActiveUsers() < 0 ? "(n/a)" : Integer.toString(this.getNrOfActiveUsers())) + (maxUsers > 0 ? " / " + maxUsers : "") + (!a_bPassiveMode ? "</a>" : "") + "</TD><TD CLASS=\"status\" ALIGN=\"center\">" + trafficString + "</TD><TD CLASS=\"status\" ALIGN=\"right\">" + "<a href=\"/values/delay/" + this.getId() + "\">" + (!a_bPassiveMode ? (perfEntry != null && System.currentTimeMillis() - perfEntry.getLastTestTime() < 1200000L && perfEntry.getLastTestAverage(1) != 0 ? String.valueOf(perfEntry.getLastTestAverage(1)) : "?") + " (" + (perfEntry != null && perfEntry.getAverage(1) != 0 ? String.valueOf(perfEntry.getAverage(1)) : "?") + ") " : "") + (!a_bPassiveMode ? "[" : "");
        int delayBound = perfEntry == null ? 0 : perfEntry.getBound(1).getBound();
        htmlTableLine = delayBound == Integer.MAX_VALUE ? htmlTableLine + ">" + PerformanceEntry.BOUNDARIES[1][PerformanceEntry.BOUNDARIES[1].length - 2] : (delayBound <= 0 ? htmlTableLine + "?" : htmlTableLine + delayBound);
        htmlTableLine = htmlTableLine + (!a_bPassiveMode ? "]" : "") + " ms" + "</a>" + "</TD><TD CLASS=\"status\" ALIGN=\"right\">" + "<a href=\"/values/speed/" + this.getId() + "\">" + (!a_bPassiveMode ? (perfEntry != null && System.currentTimeMillis() - perfEntry.getLastTestTime() < 1200000L && perfEntry.getLastTestAverage(0) != 0 ? String.valueOf(perfEntry.getLastTestAverage(0)) : "?") + " (" + (perfEntry != null && perfEntry.getAverage(0) != 0 ? String.valueOf(perfEntry.getAverage(0)) : "?") + ") " : "") + (!a_bPassiveMode ? "[" : "");
        int speedBound = perfEntry == null ? Integer.MAX_VALUE : perfEntry.getBound(0).getBound();
        htmlTableLine = speedBound == 0 ? htmlTableLine + "<" + PerformanceEntry.BOUNDARIES[0][1] : (speedBound < 0 || speedBound == Integer.MAX_VALUE ? htmlTableLine + "?" : htmlTableLine + speedBound);
        htmlTableLine = htmlTableLine + (!a_bPassiveMode ? "]" : "") + " kbit/s" + "</a>" + "</TD><TD CLASS=\"status\" ALIGN=\"right\">" + (this.getMixedPackets() < 0L ? "n/a" : NumberFormat.getInstance(Constants.LOCAL_FORMAT).format(this.getMixedPackets())) + "</TD><TD CLASS=\"status\">" + (this.getLastUpdate() < 0L ? "n/a" : new SimpleDateFormat("HH:mm:ss").format(new Date(this.getLastUpdate()))) + "</TD></TR>";
        return htmlTableLine;
    }

    public Node generateMixCascadeCurrentStatus() {
        Document doc = XMLUtil.createDocument();
        Element currentStatusNode = doc.createElement("CurrentStatus");
        currentStatusNode.setAttribute("CurrentRisk", Integer.toString(this.getCurrentRisk()));
        currentStatusNode.setAttribute("TrafficSituation", Integer.toString(this.getTrafficSituation()));
        currentStatusNode.setAttribute("ActiveUsers", Integer.toString(this.getNrOfActiveUsers()));
        currentStatusNode.setAttribute("MixedPackets", Long.toString(this.getMixedPackets()));
        currentStatusNode.setAttribute("LastUpdate", Long.toString(this.getLastUpdate()));
        return currentStatusNode;
    }

    private Element generateXmlRepresentation() {
        Document doc = XMLUtil.createDocument();
        Element mixCascadeStatusNode = doc.createElement(XML_ELEMENT_NAME);
        mixCascadeStatusNode.setAttribute("id", this.getId());
        mixCascadeStatusNode.setAttribute("currentRisk", Integer.toString(this.getCurrentRisk()));
        mixCascadeStatusNode.setAttribute("mixedPackets", Long.toString(this.getMixedPackets()));
        mixCascadeStatusNode.setAttribute("nrOfActiveUsers", Integer.toString(this.getNrOfActiveUsers()));
        mixCascadeStatusNode.setAttribute("trafficSituation", Integer.toString(this.getTrafficSituation()));
        mixCascadeStatusNode.setAttribute("LastUpdate", Long.toString(this.getLastUpdate()));
        return mixCascadeStatusNode;
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, XMLUtil.toXMLDocument(this.m_statusXmlDataBytes).getDocumentElement(), true);
        }
        catch (XMLParseException ex) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

