/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.multicast.messages;

import anon.crypto.SignatureCreator;
import anon.util.Base64;
import anon.util.XMLUtil;
import anon.util.ZLibTools;
import infoservice.agreement.logging.GiveThingsAName;
import infoservice.agreement.multicast.AgreementMessageTypes;
import infoservice.agreement.multicast.interfaces.IAgreementMessage;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AMessage
implements IAgreementMessage {
    protected String m_lastCommonRandom;
    protected String m_consensusId = "";
    protected String m_initiatorsId;
    protected int m_messageType = -1;
    protected String m_proposal = "";
    protected String m_senderId = "";
    protected boolean m_signatureOk = true;
    protected Document m_xmlNode = null;
    private byte[] m_compressedData = null;

    protected AMessage(String a_consensusId, int a_messageType, String a_initiatorsId, String p_proposal, String lastCommonRandom) {
        this.m_messageType = a_messageType;
        this.m_initiatorsId = a_initiatorsId;
        this.m_proposal = p_proposal;
        this.m_lastCommonRandom = lastCommonRandom;
        this.m_consensusId = a_consensusId == null && a_messageType == 0 ? this.createConsensusId() : a_consensusId;
    }

    protected abstract void appendCustomNodes(Document var1, Node var2);

    private String createConsensusId() {
        SHA1Digest digest = new SHA1Digest();
        byte[] proposalBytes = (this.m_initiatorsId + this.m_lastCommonRandom).getBytes();
        digest.update(proposalBytes, 0, proposalBytes.length);
        byte[] tmp = new byte[digest.getDigestSize()];
        digest.doFinal(tmp, 0);
        return Base64.encode(tmp, false);
    }

    @Override
    public String getConsensusId() {
        return this.m_consensusId;
    }

    @Override
    public String getHashKey() {
        StringBuffer buf = new StringBuffer();
        buf.append("Initiator: " + this.getInitiatorsId());
        buf.append(" <" + AgreementMessageTypes.getTypeAsString(this.getMessageType()) + ">");
        buf.append(" Proposal: " + this.getProposal());
        buf.append(" LCR: " + this.m_lastCommonRandom.toString());
        buf.append(" Sender: ").append(this.m_senderId);
        return buf.toString();
    }

    @Override
    public String getId() {
        return this.m_consensusId;
    }

    public String getInitiatorsId() {
        return this.m_initiatorsId;
    }

    public String getLastCommonRandom() {
        return this.m_lastCommonRandom;
    }

    @Override
    public int getMessageType() {
        return this.m_messageType;
    }

    @Override
    public synchronized byte[] getPostData() {
        if (this.m_compressedData == null) {
            this.m_compressedData = ZLibTools.compress(XMLUtil.toByteArray(this.toXML()));
        }
        return this.m_compressedData;
    }

    @Override
    public String getPostFile() {
        return "/agreement";
    }

    @Override
    public int getPostEncoding() {
        return 1;
    }

    public String getProposal() {
        return this.m_proposal;
    }

    public String getSenderId() {
        return this.m_senderId;
    }

    @Override
    public boolean isSignatureOK() {
        return this.m_signatureOk;
    }

    public void setConsensusId(String a_id) {
        this.m_consensusId = a_id;
    }

    public void setProposal(String a_proposal) {
        this.m_proposal = a_proposal;
    }

    @Override
    public void setSignatureOk(boolean a_ok) {
        this.m_signatureOk = a_ok;
    }

    @Override
    public void setXmlDocument(Document a_node) {
        this.m_xmlNode = a_node;
    }

    public String toString() {
        String name = GiveThingsAName.getNameForNumber(this.getInitiatorsId());
        StringBuffer buf = new StringBuffer();
        buf.append("ConsensusID: " + this.m_consensusId.substring(0, 2));
        buf.append(" Initiator: " + name);
        buf.append(" <" + AgreementMessageTypes.getTypeAsString(this.getMessageType()) + ">");
        buf.append(" Propsal: " + this.getProposal());
        buf.append(" LCR: " + this.m_lastCommonRandom.substring(0, 2).toString());
        return buf.toString();
    }

    @Override
    public synchronized Document toXML() {
        if (this.m_xmlNode != null) {
            return this.m_xmlNode;
        }
        Document doc = XMLUtil.createDocument();
        Element root = doc.createElement(AgreementMessageTypes.getTypeAsString(this.m_messageType));
        doc.appendChild(root);
        Element tmp = doc.createElement("RoundNr");
        XMLUtil.setValue((Node)tmp, this.m_lastCommonRandom);
        root.appendChild(tmp);
        tmp = doc.createElement("Initiator");
        XMLUtil.setValue((Node)tmp, this.m_initiatorsId);
        root.appendChild(tmp);
        tmp = doc.createElement("Message");
        XMLUtil.setValue((Node)tmp, this.m_proposal);
        root.appendChild(tmp);
        tmp = doc.createElement("ConsensusId");
        XMLUtil.setValue((Node)tmp, this.m_consensusId);
        root.appendChild(tmp);
        this.appendCustomNodes(doc, root);
        SignatureCreator.getInstance().signXml(2, doc);
        return doc;
    }

    @Override
    public void setLastCommonRandom(String lcr) {
        this.m_lastCommonRandom = lcr;
    }
}

