/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.IMySignature;
import anon.crypto.MyDSAPrivateKey;
import anon.crypto.MyDSAPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.signers.DSASigner;

public final class MyDSASignature
implements IMySignature {
    private static final AlgorithmIdentifier ms_identifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa_with_sha1);
    private DSASigner m_SignatureAlgorithm;
    private SHA1Digest m_Digest;

    public MyDSASignature() {
        try {
            this.m_SignatureAlgorithm = new DSASigner();
            this.m_Digest = new SHA1Digest();
        }
        catch (Exception e) {
            this.m_SignatureAlgorithm = null;
        }
    }

    public synchronized void initVerify(IMyPublicKey k) throws InvalidKeyException {
        try {
            MyDSAPublicKey k1 = (MyDSAPublicKey)k;
            this.m_SignatureAlgorithm.init(false, k1.getPublicParams());
            this.m_Digest.reset();
        }
        catch (Exception ex2) {
            throw new InvalidKeyException("MyDSASignautre - initVerify - dont know how to hnalde the given key");
        }
    }

    public synchronized void initSign(IMyPrivateKey k) throws InvalidKeyException {
        try {
            MyDSAPrivateKey k1 = (MyDSAPrivateKey)k;
            this.m_SignatureAlgorithm.init(true, k1.getPrivateParams());
        }
        catch (Exception ex2) {
            throw new InvalidKeyException("MyDSASignautre - initVerify - dont know how to hnalde the given key");
        }
    }

    public synchronized boolean verify(byte[] a_message, int message_offset, int message_len, byte[] a_signature, int signature_offset, int signature_len) {
        try {
            this.m_Digest.reset();
            this.m_Digest.update(a_message, message_offset, message_len);
            byte[] hash2 = new byte[this.m_Digest.getDigestSize()];
            this.m_Digest.doFinal(hash2, 0);
            BigInteger[] rs = MyDSASignature.derDecode(a_signature, signature_offset, signature_len);
            return this.m_SignatureAlgorithm.verifySignature(hash2, rs[0], rs[1]);
        }
        catch (Throwable e) {
            LogHolder.log(7, LogType.CRYPTO, "Signature algorithm does not match!");
            return false;
        }
    }

    public synchronized boolean verify(byte[] a_message, byte[] a_signature) {
        return this.verify(a_message, 0, a_message.length, a_signature, 0, a_signature.length);
    }

    public synchronized byte[] sign(byte[] bytesToSign) {
        try {
            this.m_Digest.reset();
            this.m_Digest.update(bytesToSign, 0, bytesToSign.length);
            byte[] hash2 = new byte[this.m_Digest.getDigestSize()];
            this.m_Digest.doFinal(hash2, 0);
            BigInteger[] rs = this.m_SignatureAlgorithm.generateSignature(hash2);
            return MyDSASignature.derEncode(rs[0], rs[1]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public AlgorithmIdentifier getIdentifier() {
        return ms_identifier;
    }

    public byte[] encodeForXMLSignature(byte[] a_signature) {
        int rLength = a_signature[3];
        int sLength = a_signature[3 + rLength + 2];
        byte[] rsBuff = new byte[40];
        for (int i = 0; i < 40; ++i) {
            rsBuff[i] = 0;
        }
        int rOverLength = 0;
        if (rLength == 21) {
            rOverLength = 1;
            rLength = 20;
        }
        System.arraycopy(a_signature, 4 + rOverLength, rsBuff, 20 - rLength, rLength);
        rLength = (byte)(rLength + rOverLength);
        int sOverLength = 0;
        if (sLength == 21) {
            sOverLength = 1;
            sLength = 20;
        }
        System.arraycopy(a_signature, 4 + rLength + 2 + sOverLength, rsBuff, 40 - sLength, sLength);
        return rsBuff;
    }

    public byte[] decodeForXMLSignature(byte[] a_encodedSignature) {
        try {
            int index = 46;
            if (a_encodedSignature[0] < 0) {
                ++index;
            }
            if (a_encodedSignature[20] < 0) {
                ++index;
            }
            byte[] tmpBuff = new byte[index];
            tmpBuff[0] = 48;
            tmpBuff[1] = (byte)(index - 2);
            tmpBuff[2] = 2;
            if (a_encodedSignature[0] < 0) {
                index = 5;
                tmpBuff[3] = 21;
                tmpBuff[4] = 0;
            } else {
                tmpBuff[3] = 20;
                index = 4;
            }
            System.arraycopy(a_encodedSignature, 0, tmpBuff, index, 20);
            index += 20;
            tmpBuff[index++] = 2;
            if (a_encodedSignature[20] < 0) {
                tmpBuff[index++] = 21;
                tmpBuff[index++] = 0;
            } else {
                tmpBuff[index++] = 20;
            }
            System.arraycopy(a_encodedSignature, 20, tmpBuff, index, 20);
            return tmpBuff;
        }
        catch (Exception a_e) {
            return null;
        }
    }

    public String getXMLSignatureAlgorithmReference() {
        return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    }

    static byte[] derEncode(BigInteger r, BigInteger s) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(r));
        v.add(new ASN1Integer(s));
        dOut.writeObject(new DERSequence(v));
        return bOut.toByteArray();
    }

    static BigInteger[] derDecode(byte[] encoding, int off, int len) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding, off, len);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        ASN1Sequence s = (ASN1Sequence)aIn.readObject();
        try {
            aIn.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        BigInteger[] sig = new BigInteger[]{((ASN1Integer)s.getObjectAt(0)).getValue(), ((ASN1Integer)s.getObjectAt(1)).getValue()};
        return sig;
    }
}

