/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.tools;

import anon.crypto.MyRSAPrivateKey;
import anon.crypto.MyX509Extensions;
import anon.crypto.PKCS12;
import anon.crypto.X509DistinguishedName;
import anon.util.Base64;
import anon.util.JAPMessages;
import gui.JAPHelpContext;
import gui.dialog.JAPDialog;
import gui.help.JAPHelp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mixconfig.ICertCreationValidator;
import mixconfig.MixConfig;
import mixconfig.panels.CertPanel;
import mixconfig.tools.SymCipher;
import org.bouncycastle.crypto.engines.RSAEngine;

public class EncryptedLogTool
extends JAPDialog
implements ActionListener,
ChangeListener,
JAPHelpContext.IHelpContext {
    private static final String MSG_PASSWD_INFO_MSG = EncryptedLogTool.class.getName() + "_passwordInfoMessage";
    private static final String MSG_CERT_HEADLINE = EncryptedLogTool.class.getName() + "_certificateHeadline";
    private static final String MSG_CANNOT_DECRYPT = EncryptedLogTool.class.getName() + "_cannotDecrypt";
    private static final String MSG_NO_CERT = EncryptedLogTool.class.getName() + "_noCert";
    private static final String MSG_NO_LOG = EncryptedLogTool.class.getName() + "_noLog";
    private static final String MSG_REALLY_CLOSE = EncryptedLogTool.class.getName() + "_reallyClose";
    private JTextArea m_textLogFile;
    private byte[] m_arLog;
    private CertPanel m_privateCertPanel;
    private JButton m_btnChooseFile;
    private JButton m_btnDecrypt;

    public EncryptedLogTool(Frame parent) {
        super(parent, "Log Reader for encrypted Mix logs", true);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraintsContentPane = new GridBagConstraints();
        constraintsContentPane.anchor = 18;
        constraintsContentPane.insets = new Insets(10, 10, 10, 10);
        constraintsContentPane.fill = 1;
        constraintsContentPane.gridx = 0;
        constraintsContentPane.gridy = 0;
        constraintsContentPane.weightx = 1.0;
        constraintsContentPane.weighty = 1.0;
        JPanel panelLog = new JPanel(new GridBagLayout());
        panelLog.setBorder(new TitledBorder("Log File to decrypt"));
        this.getContentPane().add((Component)panelLog, constraintsContentPane);
        GridBagConstraints constraintsPanelLog = new GridBagConstraints();
        constraintsPanelLog.anchor = 17;
        constraintsPanelLog.insets = new Insets(5, 5, 5, 5);
        constraintsPanelLog.gridx = 0;
        constraintsPanelLog.gridy = 0;
        this.m_btnChooseFile = new JButton("Choose...");
        constraintsPanelLog.fill = 0;
        this.m_btnChooseFile.addActionListener(this);
        panelLog.add((Component)this.m_btnChooseFile, constraintsPanelLog);
        ++constraintsPanelLog.gridx;
        this.m_btnDecrypt = new JButton("Decrypt");
        this.m_btnDecrypt.addActionListener(this);
        panelLog.add((Component)this.m_btnDecrypt, constraintsPanelLog);
        ++constraintsPanelLog.gridx;
        panelLog.add((Component)JAPHelp.createHelpButton(this), constraintsPanelLog);
        constraintsPanelLog.gridx = 0;
        constraintsPanelLog.gridy = 1;
        constraintsPanelLog.gridwidth = 3;
        constraintsPanelLog.gridheight = 3;
        constraintsPanelLog.fill = 1;
        this.m_textLogFile = new JTextArea();
        this.m_textLogFile.setEditable(false);
        JScrollPane sp = new JScrollPane(this.m_textLogFile);
        sp.setPreferredSize(new Dimension(500, 250));
        constraintsPanelLog.weightx = 10.0;
        constraintsPanelLog.weighty = 10.0;
        panelLog.add((Component)sp, constraintsPanelLog);
        constraintsContentPane.gridx = 0;
        constraintsContentPane.gridy = 1;
        constraintsContentPane.weighty = 0.0;
        constraintsContentPane.fill = 0;
        this.m_privateCertPanel = new CertPanel(JAPMessages.getString(MSG_CERT_HEADLINE), null, (PKCS12)null, 1, 0);
        this.m_privateCertPanel.setCertCreationValidator(new LogCertCreationValidator());
        this.m_privateCertPanel.addChangeListener(this);
        this.setDefaultCloseOperation(0);
        final EncryptedLogTool thisTool = this;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent a_event) {
                boolean bClose = true;
                if (!EncryptedLogTool.this.m_privateCertPanel.isCertificateSaved()) {
                    boolean bl = bClose = JAPDialog.showConfirmDialog(thisTool, JAPMessages.getString(MSG_REALLY_CLOSE), 2, 3) == 0;
                }
                if (bClose) {
                    EncryptedLogTool.this.dispose();
                }
            }
        });
        this.getContentPane().add((Component)this.m_privateCertPanel, constraintsContentPane);
        this.pack();
        this.setVisible(true, false);
    }

    @Override
    public void stateChanged(ChangeEvent a_event) {
        if (a_event.getSource() == this.m_privateCertPanel) {
            this.pack();
        }
    }

    @Override
    public String getHelpContext() {
        return "index";
    }

    @Override
    public void actionPerformed(ActionEvent a_event) {
        if (a_event.getSource() == this.m_btnDecrypt) {
            if (this.m_arLog == null || this.m_arLog.length == 0) {
                JAPDialog.showErrorDialog((JAPDialog)this, JAPMessages.getString(MSG_NO_LOG));
            } else if (this.m_privateCertPanel.getCert() == null) {
                JAPDialog.showErrorDialog((JAPDialog)this, JAPMessages.getString(MSG_NO_CERT));
            } else {
                try {
                    this.doDecrypt();
                }
                catch (Throwable a_e) {
                    JAPDialog.showErrorDialog((JAPDialog)this, JAPMessages.getString(MSG_CANNOT_DECRYPT), a_e);
                }
            }
        } else if (a_event.getSource() == this.m_btnChooseFile) {
            try {
                byte[] buff = MixConfig.openFile(this.getContentPane(), 0);
                this.m_textLogFile.setText(new String(buff));
                this.m_textLogFile.revalidate();
                this.m_arLog = buff;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doDecrypt() {
        byte b;
        int i = 0;
        int len = this.m_arLog.length;
        while (true) {
            byte b2;
            if (i >= len) {
                return;
            }
            if ((b2 = this.m_arLog[i++]) != 10) continue;
            if (i >= len + 31) {
                return;
            }
            if (new String(this.m_arLog, i, 31).equals("----Start of EncryptionKey----\n")) break;
        }
        i += 31;
        int startOfKey = i++;
        while (true) {
            byte b3;
            if (i >= len) {
                return;
            }
            if ((b3 = this.m_arLog[i++]) != 10) continue;
            if (i >= len + 31) {
                return;
            }
            if (new String(this.m_arLog, i, 31).equals("-----End of EncryptionKey-----\n")) break;
        }
        byte[] encKey = Base64.decode(this.m_arLog, startOfKey, i - startOfKey);
        i += 31;
        int startOfMessage = i++;
        RSAEngine rsa = new RSAEngine();
        rsa.init(false, ((MyRSAPrivateKey)((PKCS12)this.m_privateCertPanel.getCert()).getPrivateKey()).getParams());
        byte[] arKey = rsa.processBlock(encKey, 0, encKey.length);
        SymCipher c = new SymCipher();
        c.setKey(arKey, 50);
        c.setIV(arKey, 66);
        while (i < len && ((b = this.m_arLog[i++]) != 10 || i < len + 31 && !new String(this.m_arLog, i, 31).equals("----Start of Encryption Key----\n"))) {
        }
        byte[] dec = new byte[i - startOfMessage];
        c.crypt(this.m_arLog, startOfMessage, dec, 0, i - startOfMessage);
        this.m_textLogFile.setText(new String(dec));
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }

    private class LogCertCreationValidator
    implements ICertCreationValidator {
        private LogCertCreationValidator() {
        }

        @Override
        public Vector<String> getInvalidityMessages() {
            return new Vector<String>();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public String getPasswordInfoMessage() {
            return JAPMessages.getString(MSG_PASSWD_INFO_MSG);
        }

        @Override
        public MyX509Extensions getExtensions() {
            return new MyX509Extensions(new Vector());
        }

        @Override
        public X509DistinguishedName getSigName() {
            return new X509DistinguishedName("CN=Mixlog Encryption Certificate");
        }
    }
}

