/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ChunkedInputStream;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HttpHeaderElement;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.UncompressInputStream;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

class TransferEncodingModule
implements HTTPClientModule,
GlobalConstants {
    TransferEncodingModule() {
    }

    /*
     * WARNING - void declaration
     */
    public int requestHandler(Request req, Response[] resp) throws ModuleException {
        void var5_5;
        Vector pte;
        NVPair[] hdrs = req.getHeaders();
        int idx = Util.getIndex(hdrs, "TE");
        if (idx == -1) {
            idx = hdrs.length;
            hdrs = Util.resizeArray(hdrs, idx + 1);
            req.setHeaders(hdrs);
            pte = new Vector();
        } else {
            try {
                pte = Util.parseHeader(hdrs[idx].getValue());
            }
            catch (ParseException pe) {
                throw new ModuleException(pe.toString());
            }
        }
        HttpHeaderElement all = Util.getElement((Vector)var5_5, "*");
        if (all != null) {
            NVPair[] params = all.getParams();
            for (idx = 0; idx < params.length && !params[idx].getName().equalsIgnoreCase("q"); ++idx) {
            }
            if (idx == params.length) {
                return 0;
            }
            if (params[idx].getValue() == null || params[idx].getValue().length() == 0) {
                throw new ModuleException("Invalid q value for \"*\" in TE header: ");
            }
            try {
                if ((double)Float.valueOf(params[idx].getValue()).floatValue() > 0.0) {
                    return 0;
                }
            }
            catch (NumberFormatException nfe) {
                throw new ModuleException("Invalid q value for \"*\" in TE header: " + nfe.getMessage());
            }
        }
        if (!var5_5.contains(new HttpHeaderElement("deflate"))) {
            var5_5.addElement(new HttpHeaderElement("deflate"));
        }
        if (!var5_5.contains(new HttpHeaderElement("gzip"))) {
            var5_5.addElement(new HttpHeaderElement("gzip"));
        }
        if (!var5_5.contains(new HttpHeaderElement("compress"))) {
            var5_5.addElement(new HttpHeaderElement("compress"));
        }
        hdrs[idx] = new NVPair("TE", Util.assembleHeader((Vector)var5_5));
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    /*
     * WARNING - void declaration
     */
    public void responsePhase3Handler(Response resp, RoRequest req) throws IOException, ModuleException {
        void var4_4;
        String te = resp.getHeader("Transfer-Encoding");
        if (te == null || req.getMethod().equals("HEAD")) {
            return;
        }
        try {
            Vector pte = Util.parseHeader(te);
        }
        catch (ParseException pe) {
            throw new ModuleException(pe.toString());
        }
        while (var4_4.size() > 0) {
            String encoding = ((HttpHeaderElement)var4_4.lastElement()).getName();
            if (encoding.equalsIgnoreCase("gzip")) {
                resp.inp_stream = new GZIPInputStream(resp.inp_stream);
            } else if (encoding.equalsIgnoreCase("deflate")) {
                resp.inp_stream = new InflaterInputStream(resp.inp_stream);
            } else if (encoding.equalsIgnoreCase("compress")) {
                resp.inp_stream = new UncompressInputStream(resp.inp_stream);
            } else if (encoding.equalsIgnoreCase("chunked")) {
                resp.inp_stream = new ChunkedInputStream(resp.inp_stream);
            } else if (!encoding.equalsIgnoreCase("identity")) break;
            var4_4.removeElementAt(var4_4.size() - 1);
        }
        if (var4_4.size() > 0) {
            resp.setHeader("Transfer-Encoding", Util.assembleHeader((Vector)var4_4));
        } else {
            resp.deleteHeader("Transfer-Encoding");
        }
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }
}

