/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.mac.MacLookAndFeel;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class MacComboBoxUI
extends BasicComboBoxUI {
    protected JButton createArrowButton() {
        return null;
    }

    protected ComboPopup createPopup() {
        return new MacComboPopup(this.comboBox);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MacComboBoxUI();
    }

    protected int getButtonLeft() {
        return this.getButtonLeft(this.comboBox.getInsets());
    }

    protected int getButtonLeft(Insets insets) {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        return n - 1 - (insets.right + this.getButtonWidth(insets));
    }

    protected int getButtonWidth() {
        return this.getButtonWidth(this.comboBox.getInsets());
    }

    protected int getButtonWidth(Insets insets) {
        return this.getButtonWidth(insets, this.comboBox.getHeight());
    }

    protected int getButtonWidth(Insets insets, int n) {
        int n2 = n - (insets.top + insets.bottom);
        n2 *= 21;
        return n2 /= 19;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = null;
        Insets insets = this.comboBox.getInsets();
        int n = 4;
        if (!this.comboBox.isEditable()) {
            dimension = this.getDisplaySize();
            dimension.height += 4 + insets.top + insets.bottom;
            dimension.width += this.getButtonWidth(insets, dimension.height) + insets.left + insets.right + 2;
        } else if (this.comboBox.isEditable() && this.editor != null) {
            dimension = this.getDisplaySize();
            dimension.height = Math.max(this.editor.getMinimumSize().height, dimension.height);
            if (this.editor instanceof JComponent) {
                Insets insets2 = ((JComponent)this.editor).getInsets();
                dimension.height += insets2.top + insets2.bottom;
            }
            dimension.height += 4 + insets.top + insets.bottom;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize = dimension;
        this.isMinimumSizeDirty = false;
        return new Dimension(dimension);
    }

    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        if (this.arrowButton != null) {
            this.comboBox.add(this.arrowButton);
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.setRequestFocusEnabled(false);
    }

    public boolean isFocusTraversable(JComboBox jComboBox) {
        return false;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(graphics, rectangle, this.hasFocus);
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
        graphics.translate(insets.left, insets.top);
        this.paintBorder(graphics, jComponent, insets);
        this.paintIcon(graphics, jComponent, insets);
        graphics.translate(-insets.left, -insets.top);
    }

    protected void paintBorder(Graphics graphics, JComponent jComponent, Insets insets) {
        int n = jComponent.getWidth() - 1 - insets.right;
        int n2 = jComponent.getHeight() - 1 - insets.bottom;
        graphics.setColor(MacLookAndFeel.getBlack());
        graphics.drawLine(0, 2, 0, n2 - 2);
        graphics.drawLine(1, 1, 1, 1);
        graphics.drawLine(2, 0, n - 2, 0);
        graphics.drawLine(n - 1, 1, n - 1, 1);
        graphics.drawLine(n, 2, n, n2 - 2);
        graphics.drawLine(n - 1, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(2, n2, n - 2, n2);
        graphics.drawLine(1, n2 - 1, 1, n2 - 1);
        int n3 = n - this.getButtonWidth(insets);
        graphics.setColor(MacLookAndFeel.getWhite());
        graphics.drawLine(2, 1, n3 - 1, 1);
        graphics.drawLine(1, 2, 1, n2 - 2);
        graphics.setColor(MacLookAndFeel.getGray4());
        graphics.drawLine(2, n2 - 1, n3 - 1, n2 - 1);
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Insets insets) {
        int n = jComponent.getWidth() - 1 - insets.right;
        int n2 = jComponent.getHeight() - 1 - insets.bottom;
        int n3 = this.getButtonLeft(insets);
        graphics.setColor(MacLookAndFeel.getWhite());
        graphics.drawLine(n3 + 2, 2, n3 + 2, n2 - 3);
        graphics.drawLine(n3 + 2, 2, n - 3, 2);
        graphics.setColor(MacLookAndFeel.getGray4());
        graphics.drawLine(n3, 2, n3, n2 - 1);
        graphics.drawLine(n3 + 3, n2 - 2, n - 3, n2 - 2);
        graphics.drawLine(n - 2, 3, n - 2, n2 - 2);
        graphics.drawLine(n - 1, 2, n - 1, 2);
        graphics.setColor(MacLookAndFeel.getGray3());
        graphics.drawLine(n - 2, 1, n - 2, 1);
        graphics.drawLine(n3 + 1, n2 - 1, n3 + 1, n2 - 1);
        graphics.setColor(MacLookAndFeel.getGray7());
        graphics.drawLine(n - 1, 2, n - 1, n2 - 2);
        graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
        graphics.drawLine(n3 + 2, n2 - 1, n - 2, n2 - 1);
        graphics.setColor(MacLookAndFeel.getBlack());
        int n4 = jComponent.getHeight() / 4;
        int n5 = jComponent.getHeight() / 2;
        int n6 = n5 - Math.max(1, n4 / 4) - n4;
        int n7 = this.getButtonLeft() + this.getButtonWidth(insets) / 2;
        int n8 = 0;
        while (n8 < n4) {
            graphics.drawLine(n7 - n8, n6 + n8, n7 + n8, n6 + n8);
            ++n8;
        }
        int n9 = n5 + Math.max(1, n4 / 4) + n4 - 1;
        int n10 = 0;
        while (n10 < n4) {
            graphics.drawLine(n7 - n10, n9 - n10, n7 + n10, n9 - n10);
            ++n10;
        }
    }

    protected Rectangle rectangleForCurrentValue() {
        Insets insets = this.comboBox.getInsets();
        int n = this.comboBox.getHeight();
        return new Rectangle(insets.left + 2, insets.top + 2, this.getButtonLeft(insets) - (insets.left + 2), n - (insets.top + insets.bottom + 4));
    }

    public static class MacComboPopup
    extends BasicComboPopup {
        public MacComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
            boolean bl = this.inModalDialog();
            Rectangle rectangle = this.comboBox.getBounds();
            int n5 = this.comboBox.getModel().getSize();
            Rectangle rectangle2 = new Rectangle(0, n2, n3, n4);
            if (n5 > 0) {
                boolean bl2;
                Point point;
                Point point2;
                Rectangle rectangle3 = this.list.getCellBounds(0, 0);
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                int n6 = this.getPopupHeightForRowCount(n5);
                int n7 = this.comboBox.getSelectedIndex();
                int n8 = this.getPopupHeightForRowCount(n7 + 1) - 2;
                n8 -= rectangle3.height;
                if (bl) {
                    Dialog dialog = this.getDialog();
                    point2 = SwingUtilities.convertPoint(dialog, 0, 0, this.comboBox);
                    point = SwingUtilities.convertPoint(dialog, 0, dialog.getSize().height - 1, this.comboBox);
                } else {
                    point2 = new Point(0, 0);
                    SwingUtilities.convertPointFromScreen(point2, this.comboBox);
                    point = new Point(0, dimension.height - 1);
                    SwingUtilities.convertPointFromScreen(point, this.comboBox);
                }
                int n9 = n6 - n8;
                JViewport jViewport = this.scroller.getViewport();
                Point point3 = jViewport.getViewPosition();
                boolean bl3 = point2.y + n8 > 0;
                boolean bl4 = bl2 = n9 > point.y - 2;
                if (bl3) {
                    rectangle2.y = point2.y + 1;
                    int n10 = n8 + point2.y;
                    jViewport.setViewPosition(new Point(point3.x, n10));
                    rectangle2.height = bl2 ? dimension.height - 4 : n6 - n10;
                } else {
                    rectangle2.y = -n8 + 1;
                    jViewport.setViewPosition(new Point(point3.x, 0));
                    rectangle2.height = bl2 ? point.y - rectangle2.y - 2 : n6;
                }
            } else {
                return super.computePopupBounds(n, n2, n3, n4);
            }
            return rectangle2;
        }

        protected void configureScroller() {
            super.configureScroller();
            ScrollPaneLayout scrollPaneLayout = (ScrollPaneLayout)this.scroller.getLayout();
            scrollPaneLayout.setVerticalScrollBarPolicy(21);
            scrollPaneLayout.setHorizontalScrollBarPolicy(31);
            this.scroller.invalidate();
        }

        protected JScrollPane createScroller() {
            return new JScrollPane(this.list, 21, 31);
        }

        public void delegateFocus(MouseEvent mouseEvent) {
        }

        private Dialog getDialog() {
            Container container = this.comboBox.getParent();
            while (container != null && !(container instanceof Dialog) && !(container instanceof Window)) {
                container = container.getParent();
            }
            if (container instanceof Dialog) {
                return (Dialog)container;
            }
            return null;
        }

        private boolean inModalDialog() {
            return this.getDialog() != null;
        }

        public void show() {
            Dimension dimension = this.comboBox.getSize();
            dimension.setSize(dimension.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
            this.scroller.setMaximumSize(rectangle.getSize());
            this.scroller.setPreferredSize(rectangle.getSize());
            this.scroller.setMinimumSize(rectangle.getSize());
            this.list.invalidate();
            this.list.setSelectedIndex(this.comboBox.getSelectedIndex());
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
            this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
            this.show(this.comboBox, rectangle.x, rectangle.y);
        }
    }
}

